function [sys,E,Ep]=Rampe(Epi,Epf,pente,m,varargin)
% Etats confins d'un objet physique dans une nergie potentielle linaire
%   >> pente    = Pente de l'nergie potentielle (J/m)
%   >> m        = Masse (par rapport  l'lectron) de l'objet physique
%   >> varargin     = Arguments d'entre optionnels
%           >> nx   = Nombre de point selon Ox (dfaut : 100)
%           >> nE   = Nombre de valeurs de l'nergie (dfaut : 1000)
%           >> Emin = Valeur minimale de l'nergie (dfaut : min(Ep))
%           >> Emax = Valeur maximale de l'nergie (dfaut : Ep(max(x)))
%
% Olivier Pujol : septembre 2013

%% Vrifications diverses

if (length(varargin)>4), error('Mauvais nombre d''arguments d''entre optionnels');end
if (nargin-length(varargin)~=4),error('Mauvais nombre d''arguments d''entre non optionnels');end
if (abs(pente)<=eps),error('La pente est nulle');end

if (pente>0 && Epi>Epf),error('Problme dans les donnes nergtiques d''entre');end
if (pente<0 && Epf>Epi),error('Problme dans les donnes nergtiques d''entre');end

%% Arguments d'entre optionnels

switch length(varargin)
    case 0
        nx=100;                     % Valeur par dfaut du nombre de points selon Ox
        nE=500;                     % Valeur par dfaut du nombre de valeurs de l'nergie
    case 1
        nx=varargin{1};             % Valeur par dfaut du nombre de points selon Ox
        nE=500;                     % Valeur par dfaut du nombre de valeurs de l'nergie
    case 2
        nx=varargin{1};             % Valeur par dfaut du nombre de points selon Ox
        nE=varargin{2};             % Valeur par dfaut du nombre de valeurs de l'nergie
    case 4
        nx=varargin{1};             
        nE=varargin{2};             
        E=linspace(varargin{3},varargin{4},nE);     % Ensemble des valeurs de l'nergie
    otherwise
        ('Mauvais nombre d''arguments d''entre optionnels');
end

%% Energie potentielle

% Construction
x=linspace(0,(Epf-Epi)/pente,nx);       % Domaine spatial 
Epc=pente*x+Epi;                        % Energie potentielle linaire (pente en eV/nm)

% Discrtisation
[M,xt,Ep]=discretisation(x,Epc);

% On ajoute les marches initiale et finale, d'nergie respective Epi en x=0
% et Epf en x=(Epf-Epi)/pente
M=['Mi' M 'Mf'];
Ep=[Epi;Ep;Epf];
xt=[0;xt;(Epf-Epi)/pente];

% Ensemble des valeurs de l'nergie
if (length(varargin)~=4 && pente >0)
    E=linspace(Epi,2*Epf,nE);
end    
if (length(varargin)~=4 && pente <0)
    E=linspace(2*Epi,Epf,nE);
end    

%% Etats confins

[sys,E]=Epot(M,xt,Ep,m,E);          % Fabrication du systme
TES=matrix(sys);
[R,T]=factRT(sys,TES);
graphE(sys,E,T);

return;